<?php
// start_test.php
$config = require __DIR__ . '/config.php';

$error = '';
$started = false;
$target = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $target = trim($_POST['target'] ?? '');
    $urlParts = parse_url($target);
    $host = $urlParts['host'] ?? null;

    if (!$host) {
        $error = "Geçersiz URL. Örn: http://127.0.0.1:8080/";
    } elseif (!in_array($host, $config['whitelist'], true)) {
        $error = "Bu host whitelist'te değil. Sadece whitelist'teki hedeflere test yapılabilir.";
    } else {
        // Güvenlik: target whitelist kontrolünden geçti.
        $rpm = (int)$config['requests_per_minute'];
        $duration = (int)$config['duration_minutes'];

        // Arka plan komutu: nohup ile çalıştırıyoruz. Sistemde nohup ve php-cli olmalı.
        $worker = escapeshellarg(__DIR__ . '/test_worker.php');
        $targArg = escapeshellarg($target);
        $cmd = "nohup php $worker $targArg $rpm $duration > /dev/null 2>&1 &";

        // exec çalıştırılırken web sunucusu kullanıcı izinleri önemli.
        exec($cmd, $out, $rc);
        if ($rc === 0) {
            $started = true;
        } else {
            $error = "Arka plan işi başlatılamadı (rc=$rc). Sunucu izinlerini kontrol edin.";
        }
    }
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Basit Ziyaretçi Simülatörü - Test Başlatıcı</title>
  <style>
    body { font-family: Arial, sans-serif; padding: 20px; }
    input[type=text]{ width: 80%; padding:8px; }
    button{ padding:8px 12px; }
    .warn { color: #b33; }
    .ok { color: #070; }
  </style>
</head>
<body>
  <h2>Basit Ziyaretçi Simülatörü (Whitelist sınırlı)</h2>

  <?php if ($error): ?>
    <p class="warn"><?=htmlspecialchars($error)?></p>
  <?php endif; ?>
  <?php if ($started): ?>
    <p class="ok">Test başlatıldı: <?=htmlspecialchars($target)?> — <?=htmlspecialchars($config['requests_per_minute'])?> istek/dk, <?=htmlspecialchars($config['duration_minutes'])?> dakika.</p>
    <p>Arka planda çalışan iş `test_worker.php` tarafından yürütülüyor. Log dosyası: <?=htmlspecialchars($config['log_file'])?></p>
  <?php endif; ?>

  <form method="post">
    <label>Hedef URL (sadece whitelist'te kayıtlı hostlar):</label><br>
    <input type="text" name="target" placeholder="http://127.0.0.1:8080/" value="<?=htmlspecialchars($target)?>"><br><br>
    <button type="submit">Ziyaret Et / Test Başlat</button>
  </form>

  <h3>Whitelist (izin verilen hostlar)</h3>
  <ul>
    <?php foreach ($config['whitelist'] as $w): ?>
      <li><?=htmlspecialchars($w)?></li>
    <?php endforeach; ?>
  </ul>

  <h3>Notlar</h3>
  <ul>
    <li>Bu arayüz sadece testi <strong>başlatır</strong>. İş arka planda PHP CLI ile çalışır.</li>
    <li>Sunucuda <code>nohup</code> ve PHP CLI (php komutu) olmalı. Apache/Nginx kullanıcı izinleri arka planda komut çalıştırma yetkisini etkileyebilir.</li>
    <li>Harici hedeflere test yapmadan önce hedef sahibinden yazılı izin alın.</li>
  </ul>
</body>
</html>
